package gov.va.vamf.scheduling.facility.datalayer;

import com.agilex.healthcare.utility.NullChecker;
import gov.va.vamf.scheduling.facility.domain.CDWFacilities;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FacilityFilter implements Serializable {

	private static final long serialVersionUID = -6205640205800235431L;

	private List<String> parentSiteCodes = new LinkedList<>();
	private FacilityCache facilityCache;

	public FacilityFilter(FacilityCache facilityCache) {
		this.facilityCache = facilityCache;
	}

	public void setParentSiteCode(List<String> parentSiteCodes) {
		this.parentSiteCodes = new LinkedList<>(parentSiteCodes);
	}

	public Map<Integer, CDWFacilities> filter() {
		Map<Integer, CDWFacilities> filteredFacilities = new HashMap<>();
 		for (String siteCode : parentSiteCodes) {
			CDWFacilities facilities = facilityCache.getFacilities(siteCode);

			if (NullChecker.isNotNullish(facilities)) {
				filteredFacilities.put(Integer.parseInt(siteCode), facilities);
			}
		}

		return filteredFacilities;
	}
}
